/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.MessageUtils;
import org.tigris.atlas.messages.Messages;
import org.tigris.atlas.messages.Severity;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public class MessagesStringBuilder {
    
    private static final Severity ERROR = Severity.getSeverity(Severity.ERROR); 
    
    private StringBuilder errorBuilder = new StringBuilder();
    private StringBuilder infoBuilder = new StringBuilder();
    
    public MessagesStringBuilder append(Messages messages, Class clazz) {
        if (messages.hasErrorMessages()) {
            for (Object m: messages.getErrorMessages()) {
                append((Message) m, clazz);
            }
        }
        if (messages.hasInformationalMessages()) {
            for (Object m: messages.getInformationalMessages()) {
                append((Message) m, clazz);
            }
        }
        return this;
    }
    
    public MessagesStringBuilder append(Message message, Class clazz) {
        StringBuilder builder = (ERROR.equals(message.getSeverity())) 
            ? errorBuilder : infoBuilder;
        String formattedMsg = MessageUtils.getSummaryMessage(message.
                getKey(), message.getInserts(), clazz);
        builder.append(formattedMsg);
        return this;
    }

    public String getErrorString() {
        return errorBuilder.toString();
    }

    public String getInfoString() {
        return infoBuilder.toString();
    }

    public String toString() {
        return getErrorString() + "\n\r" + getInfoString();
    }


}
